<?php
/*
Copyright (c) 2011 http://ramui.com. All right reserved.
This product is protected by copyright and distributed under licenses restricting copying, distribution. Permission is granted to the public to download and use this script provided that this Notice and any statement of authorship are reproduced in every page on all copies of the script.
*/
class bbcode
{
private $autolink;
private $nofollow;
private $priview;
function __construct($nofollow,$preview)
{
		$this->nofollow=$nofollow;
		$this->preview=$preview;
}
public function format_text($text,$autolink)
{
        $e=$this->validate_bbcode($text);
		if($e!==true){return ((empty($this->preview))? false : $e);}
		$this->autolink=$autolink;
		$text=fw_remove_smarttag($text);
		$text=htmlspecialchars($text,ENT_NOQUOTES);
		$text=str_replace("\r","",$text);
		$text=str_replace("\n[ul]","[ul]",str_replace("[/ul]\n","[/ul]",$text));
		$text=str_replace("\n[ol]","[ol]",str_replace("[/ol]\n","[/ol]",$text));
		$text=str_replace("\n[li]","[li]",str_replace("[/li]\n","[/li]",$text));
        $this->url($text);
		return $this->convert2_html($text);
}
private function url(&$content)
{
		if($this->autolink){$content=$this->convert2_link($content);}
		$content=preg_replace("/\[url\](.+)\[\/url\]/eiUs", "\$this->geturl('\\1')", $content);
		$content=preg_replace('/\[url\=(.+)\](.+)\[\/url\]/iUs', '<a target="_blank" '.(($this->nofollow)? 'rel="nofollow" ':'').'href="$1">$2</a>', $content);
		$content=nl2br($content);
}
private function geturl($link)
{
		if(strpos($link,']')!==false){
			$x=str_replace('[','<',str_replace(']','>',$link));
			$x=strip_tags($x);
			return '<a target="_blank" '.(($this->nofollow)? 'rel="nofollow" ':'').'href="'.$x.'">'.$link.'</a>';
		}
		else{return '<a target="_blank" '.(($this->nofollow)? 'rel="nofollow" ':'').'href="'.$link.'">'.$link.'</a>';}
}
private function convert2_link($x)
{
		$x=str_replace('[url]http','[url]xttp',str_replace('[url=http','[url=xttp',$x));
		$exp='/(http|https)\:\/\/[a-zA-Z0-9\-\.]+\.[a-zA-Z]{2,4}+([^\[\ \n\r\t]*)/i';
		$x=preg_replace($exp, ' [url]${0}[/url]', $x);
		$x=str_replace('[url]xttp','[url]http',str_replace('[url=xttp','[url=http',$x));
		return $x;
}
private function convert2_html($text)
{
		if(empty($text)){return;}
		$search=array('[b]','[/b]','[u]','[/u]','[i]','[/i]','[s]','[/s]','[sup]','[/sup]','[sub]','[/sub]','[ul]','[/ul]','[ol]','[/ol]','[li]','[/li]','[quote]','[/quote]');
		$replace=array('<b>','</b>','<u>','</u>','<i>','</i>','<s>','</s>','<sup>','</sup>','<sub>','</sub>','<ul>','</ul>','<ol>','</ol>','<li>','</li>','<blockquote><p>','</p></blockquote>');
		$text=str_replace($search,$replace,$text);
		return $text;
}
private function validate_bbcode($code)
{
		$tags=array('b','u','i','s','sup','sub','ul','ol','li');
		$errors='';
		foreach($tags as $tag){$this->nested_tags($code,$errors,$tag,0);}
		if(!empty($errors)){$errors='<h1 style="color:red;">Following errors occer.</h1><ol>'.$errors.'</ol>'; return $errors;}
		return true;
}
private function nested_tags(&$content,&$errors,$tag,$offset)
{
        $start=strpos($content,'['.$tag.']',$offset);
        $end=strpos($content,'[/'.$tag.']',$offset);
		if(($start===false)&&($end===false)){return false;}
		if(($start===false)&&($end!==false)){$errors.="<li>Excess [/$tag] at character($end)!</li>";return false;}
		if(($start!==false)&&($end===false)){$errors.="<li>Unterminated [$tag] at character($start)!</li>";return false;}
		$length=strlen($tag);
        $middle=substr($content,$start+($length+2),($end-$start-($length+2)));
		$b=strpos($middle,'['.$tag.']');
		if($b!==false){$errors.="<li>Nested tag [$tag] not allowed at character($b)!</li>";return false;}
		$offset=$end +$length+3;
		$this->nested_tags($content,$errors,$tag,$offset);
}
}
?>